﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml.Linq;
using Microsoft.Office.Tools.Excel;
using Microsoft.VisualStudio.Tools.Applications.Runtime;
using Excel = Microsoft.Office.Interop.Excel;
using Office = Microsoft.Office.Core;

namespace SkoroszytWinForms
{
    public partial class Arkusz1
    {
        List<double> listaWartosci = new List<double>();

        private void Arkusz1_Startup(object sender, System.EventArgs e)
        {
            comboBox2.DataSource = System.Enum.GetValues(typeof(Excel.XlChartType));
        }

        private void Arkusz1_Shutdown(object sender, System.EventArgs e)
        {
        }

        #region VSTO Designer generated code

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InternalStartup()
        {
            this.button1.Click += new System.EventHandler(this.button1_Click);
            this.comboBox1.SelectedIndexChanged += new System.EventHandler(this.comboBox1_SelectedIndexChanged);
            this.button2.Click += new System.EventHandler(this.button2_Click);            
            this.Startup += new System.EventHandler(this.Arkusz1_Startup);
            this.Shutdown += new System.EventHandler(this.Arkusz1_Shutdown);            
        }

        #endregion

        private void button1_Click(object sender, EventArgs e)
        {
            Random r = new Random();           
            const short iloscKolumn = 4,
                iloscWierszy = 10;

            listaWartosci.Clear();

            for (int i = 1; i <= iloscWierszy; i++)
            {
                for (int j = 1; j <= iloscKolumn; j++)
                {
                    // Omijamy wiersz nagłówka
                    Excel.Range zakres = Globals.Arkusz1.Cells[i + 1, j];
                    zakres.Value2 = r.NextDouble();
                    listaWartosci.Add(zakres.Value2);
                }
            }
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox1.SelectedIndex != -1 && listaWartosci.Count > 0)
            {
                String adresKomorkiWynikowej = "F4";
                Excel.Range komorkaWynikowa = Globals.Arkusz1.Range[adresKomorkiWynikowej];

                switch (comboBox1.SelectedIndex)
                {
                    case 0 :
                        komorkaWynikowa.Value2 = listaWartosci.Sum();
                        break;
                    case 1:
                        komorkaWynikowa.Value2 = listaWartosci.Average();
                        break;
                    case 2:
                        komorkaWynikowa.Value2 = listaWartosci.Min();
                        break;
                    case 3:
                        komorkaWynikowa.Value2 = listaWartosci.Max();
                        break;
                    default:
                        komorkaWynikowa.Value2 = "Wybierz poprawną funkcję";
                        break;
                }
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (comboBox2.SelectedIndex != -1)
            {
                Excel.Range zakresKreslenia = Globals.Arkusz1.Range["A2", "D11"];
                Globals.Wykres1.SetSourceData(zakresKreslenia,
                    Microsoft.Office.Interop.Excel.XlRowCol.xlColumns);
                Globals.Wykres1.ChartType = (Excel.XlChartType)comboBox2.SelectedValue;                
                Globals.Wykres1.Activate();
            }
            else
                MessageBox.Show("Nie dokonano poprawnego wyboru typu wykresu", this.Name);
        }

    }
}
